/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ComponenteFiscalidad {
    private PagoLocalExterior modeloDatos;
    private ModeloValoresPagoLocal modeloValores;
    private final Periodo periodo;
    private ElementoNombreValor<String> tipoRegimenFiscal;
    private ComboViewer cvRegimenFiscalExterior;
    private Combo cmbTipoRegimenFiscal;
    private ComboViewer cvPaisRegimenGeneral;
    private Combo cmbPaisRegimenGeneral;
    private ComboViewer cvPaisParaisoFiscal;
    private Combo cmbPaisParaisoFiscal;
    private Text txtDenominacion;
    private ComboViewer cvPaises;
    private Combo cmbPaises;
    private boolean esPaisRegimenGeneral;
    private boolean esParaidoFiscal;
    private boolean esDenominacion;

    public ComponenteFiscalidad(PagoLocalExterior modeloDatos, Periodo periodo) {
        this.modeloDatos = modeloDatos;
        this.modeloValores = new ModeloValoresPagoLocal(periodo.getFechaDeclarada());
        this.modeloValores.inicializaPeriodo(periodo);
        this.modeloValores.inicializar();
        this.periodo = periodo;
    }

    public void inicializarViews() {
        String codigoPaisRegimenGeneral = this.modeloDatos.getFiscalidad().getPaisRegimenGeneral();
        String codigoPaisParaisoFiscal = this.modeloDatos.getFiscalidad().getPaisParaisoFiscal();
        String codigoPais = this.modeloDatos.getFiscalidad().getPaisPago();
        String codigoTpRegimenFiscal = this.modeloDatos.getFiscalidad().getTipoRegimenFiscalExterior();
        this.tipoRegimenFiscal = this.modeloValores.obtenerTipoRegimenFicalDelExterior(codigoTpRegimenFiscal);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvRegimenFiscalExterior, this.tipoRegimenFiscal);
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            ElementoNombreValor paisRegimenGeneral = this.modeloValores.obtenerPaisRegimenGeneral(codigoPaisRegimenGeneral);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvPaisRegimenGeneral, (Object)paisRegimenGeneral);
            ElementoNombreValor paisParaisoFiscal = this.modeloValores.obtenerPaisParaisoFiscal(codigoPaisParaisoFiscal);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvPaisParaisoFiscal, (Object)paisParaisoFiscal);
        }
        ElementoNombreValor pais = this.modeloValores.obtenerPais(codigoPais);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvPaises, (Object)pais);
    }

    public void determinarTipoRegimen() {
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.esPaisRegimenGeneral = false;
            this.esParaidoFiscal = false;
            this.esDenominacion = false;
            if (this.tipoRegimenFiscal != null) {
                this.esPaisRegimenGeneral = "01".equals(this.tipoRegimenFiscal.getValor());
                this.esParaidoFiscal = "02".equals(this.tipoRegimenFiscal.getValor());
                this.esDenominacion = "03".equals(this.tipoRegimenFiscal.getValor());
            }
        }
    }

    public boolean visualizarEnPantalla() {
        boolean verPregunta = false;
        verPregunta = !this.periodo.isAnexoEnPeriodoDesdeMayo2016();
        return verPregunta;
    }

    public void crearComponenteFiscalidad(Composite container, boolean esExportacion) {
        Label lblTiposDeRegmen = new Label(container, 0);
        GridData gd_lblTiposDeRegmen = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTiposDeRegmen.widthHint = 270;
        lblTiposDeRegmen.setLayoutData((Object)gd_lblTiposDeRegmen);
        lblTiposDeRegmen.setText("Tipo de r\u00e9gimen fiscal del exterior");
        this.cvRegimenFiscalExterior = new ComboViewer(container, 8);
        this.manejarSeleccionCvTipoRegimenFiscalExterior();
        this.cmbTipoRegimenFiscal = this.cvRegimenFiscalExterior.getCombo();
        GridData gd_cmbTipoRegimenFiscal = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbTipoRegimenFiscal.widthHint = 270;
        this.cmbTipoRegimenFiscal.setLayoutData((Object)gd_cmbTipoRegimenFiscal);
        Label lblPaisRegimenGeneral = new Label(container, 0);
        GridData gd_lblPaisRegimenGeneral = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPaisRegimenGeneral.widthHint = 270;
        lblPaisRegimenGeneral.setLayoutData((Object)gd_lblPaisRegimenGeneral);
        lblPaisRegimenGeneral.setText("Pa\u00eds al que se realiza el pago en r\u00e9gimen General");
        this.cvPaisRegimenGeneral = new ComboViewer(container, 8);
        this.manejarSeleccionCvPaisRegimenGeneral();
        this.cmbPaisRegimenGeneral = this.cvPaisRegimenGeneral.getCombo();
        GridData gd_cmbPaisRegimenGeneral = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPaisRegimenGeneral.widthHint = 175;
        this.cmbPaisRegimenGeneral.setLayoutData((Object)gd_cmbPaisRegimenGeneral);
        Label lblPaisParaisoFiscal = new Label(container, 0);
        GridData gd_lblPaisParaisoFiscal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPaisParaisoFiscal.widthHint = 250;
        lblPaisParaisoFiscal.setLayoutData((Object)gd_lblPaisParaisoFiscal);
        lblPaisParaisoFiscal.setText("Pa\u00eds al que se efect\u00faa el pago Para\u00edso Fiscal");
        this.cvPaisParaisoFiscal = new ComboViewer(container, 8);
        this.manejarSeleccionCvPaisParaisoFiscal();
        this.cmbPaisParaisoFiscal = this.cvPaisParaisoFiscal.getCombo();
        GridData gd_cmbPaisParaisoFiscal = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPaisParaisoFiscal.widthHint = 230;
        this.cmbPaisParaisoFiscal.setLayoutData((Object)gd_cmbPaisParaisoFiscal);
        Label lblDenominacion = new Label(container, 32);
        lblDenominacion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblDenominacion.setText("Denominaci\u00f3n del r\u00e9gimen fiscal preferente \n o jurisdicci\u00f3n de menor imposici\u00f3n");
        this.txtDenominacion = new Text(container, 2048);
        this.txtDenominacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ComponenteFiscalidad.this.txtDenominacion.selectAll();
            }
        });
        this.txtDenominacion.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        GridData gd_txtDenominacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtDenominacion.widthHint = 275;
        this.txtDenominacion.setLayoutData((Object)gd_txtDenominacion);
        Label lblPasAlQue = new Label(container, 0);
        GridData gd_lblPasAlQue = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPasAlQue.widthHint = 170;
        lblPasAlQue.setLayoutData((Object)gd_lblPasAlQue);
        if (esExportacion) {
            gd_lblPasAlQue.widthHint = 285;
            lblPasAlQue.setText("Pa\u00eds de residencia o establecimiento permanente \na quien se efect\u00faa la exportaci\u00f3n o ingreso del exterior");
        } else {
            gd_lblPasAlQue.widthHint = 195;
            lblPasAlQue.setText("Pa\u00eds al que se efect\u00faa el pago");
        }
        this.cvPaises = new ComboViewer(container, 8);
        this.cvPaises.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor pais = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (pais != null) {
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisPago((String)pais.getValor());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisPago(pais.getNombre());
                }
            }
        });
        this.cmbPaises = this.cvPaises.getCombo();
        GridData gd_cmbPaises = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPaises.widthHint = 170;
        this.cmbPaises.setLayoutData((Object)gd_cmbPaises);
    }

    private void manejarSeleccionCvTipoRegimenFiscalExterior() {
        this.cvRegimenFiscalExterior.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoRegimenFiscalExterior = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoRegimenFiscalExterior != null) {
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setTipoRegimenFiscalExterior((String)tipoRegimenFiscalExterior.getValor());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionTipoRegimenFiscalExterior(tipoRegimenFiscalExterior.getNombre());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisRegimenGeneral(null);
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisRegimenGeneral(null);
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisParaisoFiscal(null);
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisParaisoFiscal(null);
                    ComponenteFiscalidad.this.habilitarRegimenFiscalDelExterior((ElementoNombreValor<String>)tipoRegimenFiscalExterior);
                }
            }
        });
    }

    private void manejarSeleccionCvPaisRegimenGeneral() {
        this.cvPaisRegimenGeneral.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor paisRegimenGeneral = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (paisRegimenGeneral != null) {
                    ComponenteFiscalidad.this.modeloValores.encontrarPaisDelParaisoFiscal((String)paisRegimenGeneral.getValor());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisRegimenGeneral((String)paisRegimenGeneral.getValor());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisRegimenGeneral(paisRegimenGeneral.getNombre());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisPago(null);
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisPago(null);
                    ComponenteFiscalidad.this.cvPaises.refresh();
                }
            }
        });
    }

    private void manejarSeleccionCvPaisParaisoFiscal() {
        this.cvPaisParaisoFiscal.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor paisParaisoFiscal = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (paisParaisoFiscal != null) {
                    ComponenteFiscalidad.this.modeloValores.encontrarPaisDelParaisoFiscal((String)paisParaisoFiscal.getValor());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisParaisoFiscal(ComponenteFiscalidad.this.modeloValores.obtenerParaisoFiscalDelPais((String)paisParaisoFiscal.getValor()));
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisParaisoFiscal(paisParaisoFiscal.getNombre());
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setPaisPago(null);
                    ComponenteFiscalidad.this.modeloDatos.getFiscalidad().setDescripcionPaisPago(null);
                    ComponenteFiscalidad.this.cvPaises.refresh();
                }
            }
        });
    }

    private void habilitarRegimenFiscalDelExterior(ElementoNombreValor<String> tipoRegimenFiscalExterior) {
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.habilitarFiscalidad(tipoRegimenFiscalExterior);
        }
    }

    private void habilitarFiscalidad(ElementoNombreValor<String> tipoRegimenFiscalExterior) {
        boolean esRegimenGeneral = "01".equals(tipoRegimenFiscalExterior.getValor());
        this.habilitaControlesRegimenGeneral(esRegimenGeneral);
        boolean esParaisoFiscal = "02".equals(tipoRegimenFiscalExterior.getValor());
        this.habilitaControlesParaisoFiscal(esParaisoFiscal);
        boolean esDenominacionRegimenFiscal = "03".equals(tipoRegimenFiscalExterior.getValor());
        this.habilitaControlesDenominacion(esDenominacionRegimenFiscal);
    }

    private void habilitaControlesRegimenGeneral(boolean esRegimenGeneral) {
        if (esRegimenGeneral) {
            this.modeloValores.cargarPaisesRegimenGeneral();
            this.cmbPaisRegimenGeneral.setEnabled(esRegimenGeneral);
            this.cvPaisRegimenGeneral.refresh();
            this.cmbPaises.removeAll();
            this.cmbPaises.setEnabled(esRegimenGeneral);
            this.cmbPaisParaisoFiscal.removeAll();
            this.cmbPaisParaisoFiscal.setEnabled(!esRegimenGeneral);
            this.txtDenominacion.setText("");
            this.txtDenominacion.setEnabled(!esRegimenGeneral);
        }
    }

    private void habilitaControlesParaisoFiscal(boolean esParaisoFiscal) {
        if (esParaisoFiscal) {
            this.modeloValores.cargarParaisosFiscalesPorFechaDeclarada(this.periodo.getFechaDeclarada());
            this.cmbPaisParaisoFiscal.setEnabled(esParaisoFiscal);
            this.cvPaisParaisoFiscal.refresh();
            this.cmbPaises.removeAll();
            this.cmbPaises.setEnabled(esParaisoFiscal);
            this.cmbPaisRegimenGeneral.removeAll();
            this.cmbPaisRegimenGeneral.setEnabled(!esParaisoFiscal);
            this.txtDenominacion.setText("");
            this.txtDenominacion.setEnabled(!esParaisoFiscal);
        }
    }

    private void habilitaControlesDenominacion(boolean esDenominacionRegimenFiscal) {
        if (esDenominacionRegimenFiscal) {
            this.txtDenominacion.setEnabled(esDenominacionRegimenFiscal);
            this.cmbPaises.removeAll();
            this.modeloValores.cargarPaises();
            this.cmbPaises.setEnabled(esDenominacionRegimenFiscal);
            this.cvPaises.refresh();
            this.cmbPaisRegimenGeneral.removeAll();
            this.cmbPaisRegimenGeneral.setEnabled(!esDenominacionRegimenFiscal);
            this.cmbPaisParaisoFiscal.removeAll();
            this.cmbPaisParaisoFiscal.setEnabled(!esDenominacionRegimenFiscal);
        }
    }

    public void habilitarConvenioYRetencionParaPagoExteriorModoEdicion(boolean esPagoANoResidente) {
        if (this.periodo.isPeriodoDesdeEnero2013()) {
            this.cmbPaises.setEnabled(esPagoANoResidente);
            this.cmbTipoRegimenFiscal.setEnabled(esPagoANoResidente);
        }
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016() && esPagoANoResidente) {
            this.cmbPaisRegimenGeneral.setEnabled(this.esPaisRegimenGeneral);
            this.cmbPaisParaisoFiscal.setEnabled(this.esParaidoFiscal);
            this.txtDenominacion.setEnabled(this.esDenominacion);
            this.cmbPaises.setEnabled(this.esPaisRegimenGeneral || this.esParaidoFiscal || this.esDenominacion);
        } else if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.cmbTipoRegimenFiscal.setEnabled(this.esPaisRegimenGeneral || this.esParaidoFiscal || this.esDenominacion);
            this.cmbPaisRegimenGeneral.setEnabled(this.esPaisRegimenGeneral);
            this.cmbPaisParaisoFiscal.setEnabled(this.esParaidoFiscal);
            this.txtDenominacion.setEnabled(this.esDenominacion);
            this.cmbPaises.setEnabled(esPagoANoResidente || this.esPaisRegimenGeneral || this.esParaidoFiscal || this.esDenominacion);
        } else {
            this.cmbTipoRegimenFiscal.setEnabled(false);
            this.cmbPaisRegimenGeneral.setEnabled(false);
            this.cmbPaisParaisoFiscal.setEnabled(false);
            this.txtDenominacion.setEnabled(false);
            this.cmbPaises.setEnabled(esPagoANoResidente);
        }
    }

    public void habilitarPagoExteriorModuloDeExportaciones(boolean esPagoANoResidente) {
        this.cmbTipoRegimenFiscal.setEnabled(false);
        this.habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago(esPagoANoResidente);
    }

    public void habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago(boolean esPagoANoResidente) {
        this.cmbPaisRegimenGeneral.setEnabled(false);
        this.cmbPaisParaisoFiscal.setEnabled(false);
        this.txtDenominacion.setEnabled(false);
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.modeloValores.limpiarElementosDeMapas();
            this.modeloDatos.limpiarDatos(this.periodo, !esPagoANoResidente);
            this.cmbTipoRegimenFiscal.removeAll();
            this.cmbTipoRegimenFiscal.setEnabled(esPagoANoResidente);
            this.cvRegimenFiscalExterior.refresh();
            this.cmbPaisParaisoFiscal.removeAll();
            this.cmbPaisParaisoFiscal.setEnabled(esPagoANoResidente);
            this.cvPaisParaisoFiscal.refresh();
            if (!esPagoANoResidente) {
                this.modeloDatos.limpiarDatos(this.periodo, !esPagoANoResidente);
                this.cmbPaisRegimenGeneral.removeAll();
                this.cmbPaisRegimenGeneral.setEnabled(esPagoANoResidente);
                this.cvPaisRegimenGeneral.refresh();
                this.cmbPaisParaisoFiscal.removeAll();
                this.cmbPaisParaisoFiscal.setEnabled(esPagoANoResidente);
                this.cvPaisParaisoFiscal.refresh();
                this.txtDenominacion.setText("");
            } else {
                this.cmbPaisParaisoFiscal.removeAll();
                this.cmbPaisParaisoFiscal.setEnabled(esPagoANoResidente);
                this.cvPaisParaisoFiscal.refresh();
            }
            this.cmbPaises.removeAll();
            this.cmbPaises.setEnabled(esPagoANoResidente);
        } else {
            if (!esPagoANoResidente) {
                this.modeloDatos.limpiarDatos(this.periodo, !esPagoANoResidente);
                this.cmbPaises.removeAll();
                this.cvPaises.refresh();
            }
            this.cmbPaises.setEnabled(esPagoANoResidente);
        }
    }

    public DataBindingContext initDataBindingsFiscaldiad(DataBindingContext bindingContext, ObjetoModelo modeloDatos1) {
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPaises.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvPaises.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList paisesModeloValoresObserveList = PojoProperties.list((String)"paises").observe((Object)this.modeloValores);
        this.cvPaises.setInput((Object)paisesModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvRegimenFiscalExterior.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvRegimenFiscalExterior.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList modeloValoresTiposRegimenFiscalDelExteriorObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposRegimenFiscalDelExterior");
        this.cvRegimenFiscalExterior.setInput((Object)modeloValoresTiposRegimenFiscalDelExteriorObserveList);
        ObservableListContentProvider listContentProvider_3 = new ObservableListContentProvider();
        IObservableMap observeMap_3 = PojoObservables.observeMap((IObservableSet)listContentProvider_3.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPaisParaisoFiscal.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_3));
        this.cvPaisParaisoFiscal.setContentProvider((IContentProvider)listContentProvider_3);
        IObservableList modeloValoresParaisosFiscalesObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"paraisosFiscales");
        this.cvPaisParaisoFiscal.setInput((Object)modeloValoresParaisosFiscalesObserveList);
        ObservableListContentProvider listContentProvider_4 = new ObservableListContentProvider();
        IObservableMap observeMap_4 = PojoObservables.observeMap((IObservableSet)listContentProvider_4.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvPaisRegimenGeneral.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_4));
        this.cvPaisRegimenGeneral.setContentProvider((IContentProvider)listContentProvider_4);
        IObservableList modeloValoresPaisesRegimenGeneralObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"paisesRegimenGeneral");
        this.cvPaisRegimenGeneral.setInput((Object)modeloValoresPaisesRegimenGeneralObserveList);
        bindingContext = this.initDataBindingsDenominacion(bindingContext, modeloDatos1);
        return bindingContext;
    }

    public DataBindingContext initDataBindingsDenominacion(DataBindingContext bindingContext, ObjetoModelo modeloDatos2) {
        ISWTObservableValue txtDenominacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtDenominacion, (int)24);
        IObservableValue modeloDatosPagoLocalExteriorfiscalidaddenominacionRegimenObserveValue = BeansObservables.observeValue((Object)modeloDatos2, (String)"pagoLocalExterior.fiscalidad.denominacionRegimen");
        bindingContext.bindValue((IObservableValue)txtDenominacionObserveTextObserveWidget, modeloDatosPagoLocalExteriorfiscalidaddenominacionRegimenObserveValue, null, null);
        return bindingContext;
    }
}

